# Ultimate devRant Android Client

A production-grade Android devRant client with comprehensive feature coverage.

## Features

### Core Functionality
- **Feed Display** - Algorithm, Recent, and Top sorting
- **Rant Details** - Full rant text with comments and nested replies
- **Search** - Full-text rant search with tag filtering
- **User Profiles** - User information, rants, upvoted content, and comments
- **Voting** - Upvote/downvote rants and comments
- **Infinite Scroll** - Seamless pagination with load-more
- **Image Handling** - Display attached rant images with caching

### Advanced Features
- **Offline Support** - Local caching of rants and profiles
- **Dark Mode** - System theme detection
- **Analytics** - Track user behavior and trending tags
- **Search History** - Recent searches with quick access
- **User Following** - Track favorite developers
- **Feed Customization** - Filter by tags and sorting preference
- **Comments Thread** - Threaded comment display with proper nesting
- **Image Gallery** - Swipe through rant images

## API Endpoints Used

- `GET /api/devrant/rants` - Fetch feed (algo, recent, top)
- `GET /api/devrant/rants/{id}` - Get full rant with comments
- `GET /api/devrant/rants/{id}/comments` - Rant comments
- `GET /api/search/rants` - Search rants by term
- `GET /users/{id}` - User profile info
- `GET /users/{id}/rants` - User's rants
- `GET /users/{id}/upvoted` - User's upvoted rants
- `GET /users/{id}/comments` - User's comments
- `POST /api/devrant/rants/{id}/vote` - Vote on rant
- `POST /api/devrant/comments/{id}/vote` - Vote on comment

## Architecture

### Modular Structure
- **api/** - Network layer (Retrofit)
- **models/** - Data classes
- **repository/** - Data access layer
- **viewmodel/** - UI state management
- **ui/** - Fragments and Activities
- **db/** - Room database for caching

### Key Classes
- `DevRantApi` - API client
- `RantRepository` - Data source abstraction
- `FeedViewModel` - Feed list state
- `RantDetailViewModel` - Detail view state
- `UserProfileViewModel` - Profile state

## Getting Started

1. Clone and open in Android Studio
2. Update API base URL in `DevRantApi.kt`
3. Configure Gradle dependencies
4. Build and run on emulator or device

## Requirements

- Android 8.0+ (API 26)
- Kotlin 1.8+
- Android Gradle Plugin 8.0+

## Attribution

App uses the unofficial devRant API. devRant is created by dfox, aVirgulata and the devRant community.

Must credit devRant username when displaying rant content per API guidelines.